function initScrollView(config = {}) {

    const settings = {
        elements: config.elements || 'a-top',
        delay: config.delay || 0
    };

    // SelecciOn de elementos
    var anyElements = document.querySelectorAll('.' + settings.elements);
    var elementsCustom = document.querySelectorAll('.others');

    // Inicializar estados
    anyElements.forEach(function(el, index) {
        if (index === 0) {
            el.classList.remove('hidden');
        } else {
            el.classList.add('hidden');
        }
        el._done = false; 
    });

    elementsCustom.forEach(function(el) {
        el._done = false; 
    });

    var scrollTop = 0;

    // FunciOn para cachear posiciones
    function cachePositions() {
        anyElements.forEach(function(el) {
            el._top = el.getBoundingClientRect().top + window.scrollY;
        });

        elementsCustom.forEach(function(el) {
            el._top = el.getBoundingClientRect().top + window.scrollY;
        });
    }

    // Cache inicial
    cachePositions();

    // Recalcular posiciones al redimensionar
    window.addEventListener('resize', cachePositions);

    // Evento scroll con delay en las acciones
    window.addEventListener('scroll', function() {

        scrollTop = window.scrollY;

        anyElements.forEach(function(el) {

            if (el._done) return; // optimizaciOn

            if (scrollTop + window.innerHeight > el._top) {

                el._done = true; // marcar como procesado

                const ref = el;

                setTimeout(function() {
                    ref.classList.remove('hidden');
                }, settings.delay);

            }

        });

        elementsCustom.forEach(function(el) {

            if (el._done) return; // optimizaciOn

            if (scrollTop + window.innerHeight > el._top) {

                el._done = true; // marcar como procesado

                const ref = el;

                setTimeout(function() {
                    ref.style.background = 'yellow';
                }, settings.delay);

            }

        });

    });

}