/* =======================================================
   FUNCION PARA ANIMAR SCROLL (REEMPLAZO DE jQuery.animate)
======================================================= */
function animateScrollTo(targetY, duration = 400, callback = null) {

    const startY = window.scrollY;
    const diff = targetY - startY;
    const startTime = performance.now();

    function easeInOutQuad(t) {
        return t < 0.5
            ? 2 * t * t
            : -1 + (4 - 2 * t) * t;
    }

    function step(now) {
        const elapsed = now - startTime;
        const progress = Math.min(elapsed / duration, 1);
        const eased = easeInOutQuad(progress);

        window.scrollTo(0, startY + diff * eased);

        if (elapsed < duration) {
            requestAnimationFrame(step);
        } else if (callback) {
            callback();
        }
    }

    requestAnimationFrame(step);
}



/* =======================================================
   FULLPAGE SCROLL CREATE BY ENGENIUZ.COM
======================================================= */
function initScrollPage(config = {}) {

    const settings = {
        speed: config.speed || 500,
        navigation: config.navigation ?? false,  // dots
        footer: config.footer ?? false            // footer scrollable
    };

    const speedAnimation = settings.speed;

    /* ========================
       CREAR IDS Y BACKGROUNDS
    ========================= */
    let imagesList = '';
    let countSections = 0;

    document.querySelectorAll('.scrollpage .section').forEach((el, index) => {
        imagesList = el.getAttribute('src-img');
        el.id = 'section-' + (index + 1);
        el.style.backgroundImage = `url(${imagesList})`;
        countSections++;
    });

    let footerExists = false;

    if (settings.footer) {
        const footer = document.querySelector('footer');
        if (footer) {
            footer.id = 'section-' + (countSections + 1);
            footerExists = true;
        }
    }

    const totalScrollItems = countSections + (footerExists ? 1 : 0);

    let indexCount = 0;
    let wheelLocked = false;
    let hasSwiped = false;

    /* ==============================================
       MAPA DE HASHES LEIDOS DESDE .navigation
    =============================================== */
    let sectionHashMap = {};

    const navRoot = document.querySelector('.navigation ul');

    if (navRoot) {
        const navItems = navRoot.querySelectorAll('li');

        navItems.forEach(li => {
            const className = [...li.classList].find(c => c.startsWith('index-'));
            if (!className) return;

            const idx = parseInt(className.replace('index-', ''), 10);
            const href = li.querySelector('a')?.getAttribute('href');

            if (idx && href) {
                sectionHashMap[idx] = href;
            }
        });
    }

    /* =====================================================
       LEER HASH REAL DEL MENU SI ESTA EN LA URL
    ====================================================== */
    const initialHash = window.location.hash;

    if (initialHash) {
        const entry = Object.entries(sectionHashMap)
            .find(([k, v]) => v === initialHash);

        if (entry) {
            indexCount = parseInt(entry[0], 10) - 1;
        }
    }

    // Bloqueo global
    window.__FPSCROLL_LOCK__ = false;


    /* ======================
       HELPERS
    ======================= */

    function updateDots() {
        const dots = document.querySelectorAll('#fp-nav ul li');
        dots.forEach(li => li.classList.remove('active'));
        const active = document.querySelector(`#fp-nav ul li[data-index="${indexCount}"]`);
        if (active) active.classList.add('active');
    }

    function updateHash() {
        const sectionIndex = indexCount + 1;

        if (sectionIndex === 1) {
            history.replaceState(null, '', window.location.pathname);
            return;
        }

        const hash = sectionHashMap[sectionIndex];

        if (hash) {
            history.replaceState(null, '', hash);
        }
    }

    function updateExtNav() {
        if (!navRoot) return;

        const items = navRoot.querySelectorAll('li');
        items.forEach(li => li.classList.remove('active'));

        const activeLi = navRoot.querySelector(`li.index-${indexCount + 1}`);
        if (activeLi) activeLi.classList.add('active');
    }

    function finalizeSectionChange(target) {
        document.querySelectorAll('.section, footer.active').forEach(e => e.classList.remove('active'));

        if (target) target.classList.add('active');

        updateDots();
        updateExtNav();
        updateHash();
    }



    /* ========================
       BLOQUEAR SCROLL NATIVO
    ========================= */
    window.addEventListener('wheel', e => {
        if (window.__FPSCROLL_LOCK__) e.preventDefault();
    }, { passive: false });



    /* =========================
       WHEEL (DESKTOP)
    ========================= */
    window.addEventListener('wheel', function (event) {

        if (wheelLocked) {
            event.preventDefault();
            return;
        }

        if (event.deltaY > 0) {
            if (indexCount >= totalScrollItems - 1) return;
            indexCount++;
        } else {
            if (indexCount <= 0) return;
            indexCount--;
        }

        wheelLocked = true;
        window.__FPSCROLL_LOCK__ = true;

        const target = document.getElementById('section-' + (indexCount + 1));

        animateScrollTo(target.offsetTop, speedAnimation, () => {
            finalizeSectionChange(target);
            wheelLocked = false;
            window.__FPSCROLL_LOCK__ = false;
        });

    }, { passive: false });



    /* ======================
       TOUCH (MOVIL)
    ======================= */
    let touchStartY = 0;
    let touchEndY = 0;
    const swipeThreshold = 30;

    window.addEventListener('touchstart', e => {
        if (wheelLocked) return;
        hasSwiped = false;
        touchStartY = e.changedTouches[0].clientY;
    }, { passive: true });

    window.addEventListener('touchmove', e => {
        if (!e.cancelable) return;
        if (wheelLocked || hasSwiped) return;
        e.preventDefault();
    }, { passive: false });

    window.addEventListener('touchend', e => {

        if (wheelLocked || hasSwiped) return;

        touchEndY = e.changedTouches[0].clientY;
        const delta = touchStartY - touchEndY;

        if (Math.abs(delta) < swipeThreshold) return;

        hasSwiped = true;
        wheelLocked = true;
        window.__FPSCROLL_LOCK__ = true;

        if (delta > 0) {
            if (indexCount < totalScrollItems - 1) indexCount++;
        } else {
            if (indexCount > 0) indexCount--;
        }

        const target = document.getElementById('section-' + (indexCount + 1));

        animateScrollTo(target.offsetTop, speedAnimation, () => {
            finalizeSectionChange(target);
            wheelLocked = false;
            window.__FPSCROLL_LOCK__ = false;
            hasSwiped = false;
        });

    }, { passive: true });



    /* ======================
       RECALCULAR EN RESIZE
    ======================= */
    let resizeTimeout;

    window.addEventListener('resize', function () {

        clearTimeout(resizeTimeout);

        resizeTimeout = setTimeout(function () {

            wheelLocked = true;
            window.__FPSCROLL_LOCK__ = true;

            const current = document.getElementById('section-' + (indexCount + 1));

            animateScrollTo(current.offsetTop, 0, () => {
                finalizeSectionChange(current);
                wheelLocked = false;
                window.__FPSCROLL_LOCK__ = false;
            });

        }, 50);

    });



    /* ======================
         DOTS DE NAVEGACION
    ======================= */
    if (settings.navigation === true) {

        const nav = document.createElement('div');
        nav.id = 'fp-nav';
        nav.innerHTML = `<ul></ul>`;
        document.body.appendChild(nav);

        const ul = nav.querySelector('ul');

        // SOLO SECCIONES reales (footer excluido)
        const realSections = footerExists ? countSections : countSections;

        for (let i = 0; i < realSections; i++) {
            const li = document.createElement('li');
            li.dataset.index = i;
            li.innerHTML = `<a><span></span></a>`;
            ul.appendChild(li);
        }

        ul.querySelector('li')?.classList.add('active');

        nav.addEventListener('click', function (e) {

            const li = e.target.closest('li');
            if (!li || wheelLocked) return;

            indexCount = parseInt(li.dataset.index, 10);

            wheelLocked = true;
            window.__FPSCROLL_LOCK__ = true;

            const target = document.getElementById('section-' + (indexCount + 1));

            animateScrollTo(target.offsetTop, speedAnimation, () => {
                finalizeSectionChange(target);
                wheelLocked = false;
                window.__FPSCROLL_LOCK__ = false;
            });
        });
    }



    /* ====================================================
       NAV EXTERNO (.navigation) index-x
    ==================================================== */
    if (navRoot) {

        navRoot.addEventListener('click', function (e) {

            const li = e.target.closest('li');
            if (!li || wheelLocked) return;

            e.preventDefault();

            const className = [...li.classList].find(c => c.startsWith('index-'));
            if (!className) return;

            const sectionIndex = parseInt(className.replace('index-', ''), 10);
            if (isNaN(sectionIndex)) return;

            indexCount = sectionIndex - 1;

            wheelLocked = true;
            window.__FPSCROLL_LOCK__ = true;

            const target = document.getElementById('section-' + sectionIndex);

            animateScrollTo(target.offsetTop, speedAnimation, () => {
                finalizeSectionChange(target);
                wheelLocked = false;
                window.__FPSCROLL_LOCK__ = false;
            });
        });
    }



    /* ============================================
       RESTAURAR POSICION AL RECARGAR
    ============================================ */
    function restoreScrollPosition() {

        wheelLocked = true;
        window.__FPSCROLL_LOCK__ = true;

        const current = document.getElementById('section-' + (indexCount + 1));

        if (current) {
            window.scrollTo(0, current.offsetTop);

            document.querySelectorAll('.section, footer.active')
                .forEach(e => e.classList.remove('active'));

            current.classList.add('active');
        }

        updateDots();
        updateExtNav();
        updateHash();

        wheelLocked = false;
        window.__FPSCROLL_LOCK__ = false;
    }


    /* ============================================
       DETECTAR RECARGA Y REPOSICION
    ============================================ */
    const navEntries = performance.getEntriesByType("navigation");
    const isReload = navEntries.length && navEntries[0].type === "reload";

    if (isReload || initialHash) {

        restoreScrollPosition();

    } else {

        const first = document.getElementById('section-1');

        if (first) {
            document.querySelectorAll('.section, footer.active')
                .forEach(e => e.classList.remove('active'));
            first.classList.add('active');
            updateDots();
            updateExtNav();
            updateHash();
        }
    }
}
